/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.vw.api.VWException;
import filenet.vw.base.VWString;
import java.io.Serializable;

public final class VWScenarioShiftType
implements Serializable {
    private static String m_strAtWork = "ATWORK";
    private static String m_strBreak = "BREAK";
    private static String m_strVacation = "VACATION";
    private static String m_strDowntime = "DOWNTIME";
    private static final int MIN_SHIFT_TYPE = 1;
    public static final int SHIFT_TYPE_AT_WORK = 1;
    public static final int SHIFT_TYPE_BREAK = 2;
    public static final int SHIFT_TYPE_VACATION = 3;
    public static final int SHIFT_TYPE_DOWNTIME = 4;
    private static final int MAX_SHIFT_TYPE = 4;
    private static String[] LocalizedStrings = new String[]{new VWString("sim.api.VWScenarioShiftType.AtWork", "At Work").toString(), new VWString("sim.api.VWScenarioShiftType.Break", "Break").toString(), new VWString("sim.api.VWScenarioShiftType.Vacation", "Vacation").toString(), new VWString("sim.api.VWScenarioShiftType.Downtime", "Downtime").toString()};

    public static String getLocalizedString(int theShiftType) throws VWException {
        if (!VWScenarioShiftType.isValid(theShiftType)) {
            throw new VWException("sim.api.VWScenarioShiftType.BadInteger", "Integer form of the shift type is invalid: {0}", String.valueOf(theShiftType));
        }
        return LocalizedStrings[theShiftType - 1];
    }

    public static boolean isValid(int theShiftType) {
        return theShiftType >= 1 && theShiftType <= 4;
    }

    protected static String typeToString(int theShiftType) throws VWException {
        switch (theShiftType) {
            case 1: {
                return m_strAtWork;
            }
            case 2: {
                return m_strBreak;
            }
            case 3: {
                return m_strVacation;
            }
            case 4: {
                return m_strDowntime;
            }
        }
        throw new VWException("sim.api.VWScenarioShiftType.BadInteger", "Integer form of the shift type is invalid: {0}", String.valueOf(theShiftType));
    }

    protected static int stringToType(String theShiftType) throws VWException {
        if (theShiftType.equals(m_strAtWork)) {
            return 1;
        }
        if (theShiftType.equals(m_strBreak)) {
            return 2;
        }
        if (theShiftType.equals(m_strVacation)) {
            return 3;
        }
        if (theShiftType.equals(m_strDowntime)) {
            return 4;
        }
        throw new VWException("sim.api.VWScenarioShiftType.BadString", "The shift type is invalid: {0}", theShiftType);
    }
}

